<?php

defined('BASEPATH') || exit('No direct script access allowed');

class Ujian extends CI_Controller {

    var $title      = 'Halaman Pelaksana Ujian Online';
    var $status_cbt = FALSE;

    public function __construct() {
        parent::__construct();

        $this->validate_user();

        $status = $this->db->from('status_cbt')
            ->get()
            ->row();

        $this->status_cbt = $status;
    }

    public function index() {
        $siswa = $this->detailUser();

        $this->load->library('grocery_CRUD');
        $crud = new grocery_CRUD();
        $crud->set_table('detail_jadwal_ujian');
        $crud->set_subject('Jadwal Ujian');
        $crud->where('detail_jadwal_ujian.kelas', $siswa->kelas);
        $crud->where('aktif', 'YA');
        $crud->where('jurusan', $siswa->jurusan);

        $crud->set_relation('mata_pelajaran', 'mata_pelajaran', 'nama_mata_pelajaran');
        $crud->set_relation('kelas', 'master_kelas', 'nama_kelas');
        $crud->set_relation('jurusan', 'master_jurusan', 'nama_jurusan');
        $crud->set_relation('jadwal_ujian', 'jadwal_ujian', 'nama_jadwal_ujian');

        $crud->callback_column('ikut_ujian', array($this, '_cal_col_ikut_ujian'));
        $crud->columns('jadwal_ujian', 'mata_pelajaran', 'keterangan', 'kelas', 'jurusan', 'tanggal_pelaksanaan', 'ditutup', 'lama_ujian', 'ikut_ujian');

        $crud->unset_operations();

        $output = $crud->render();

        $d = $this->db->from('tata_tertib')
            ->where('aktif', 'YA')
            ->get()->row();

        $output->tata_tertib = $d;

        $this->render_page($output, 'ujian/dashboard');
    }

    public function _cal_col_ikut_ujian($value, $row) {
        $d = $this->db->select('*, NOW() as sekarang')
            ->from('detail_jadwal_ujian')
            ->where('id_detail_jadwal_ujian', $row->id_detail_jadwal_ujian)
            ->join('ujian_dilaksanakan', 'detail_jadwal_ujian = id_detail_jadwal_ujian', 'LEFT')
            ->get()
            ->row();

        $now   = strtotime($d->sekarang);
        $buka  = strtotime($d->tanggal_pelaksanaan);
        $tutup = strtotime($d->ditutup);

        if ($now > $buka && $now <= $tutup) {
            //cek apakah sudah melaksanakan ujian atau belum
            $siswa = $this->detailUser();
            $ujian = $this->db->from('ujian_dilaksanakan')
                ->where('detail_jadwal_ujian', $row->id_detail_jadwal_ujian)
                ->where('peserta', $siswa->id_peserta)
                ->get()
                ->row();

            if (!$ujian) {
                return "<a href='" . site_url('ujian/ikut_ujian/' . $row->id_detail_jadwal_ujian) . "'>Ikut Ujian</a>";
            } else {
                if ($ujian->status_ujian == "BERJALAN") {
                    return "<a href='" . site_url('ujian/fdo_ujian/' . $ujian->id_ujian_dilaksanakan) . "'>Sedang dilaksanakan</a>";
                } else {
                    //return "<a href='" . site_url('ujian/hasil_ujian/' . $ujian->id_ujian_dilaksanakan) . "'>Sudah dilaksanakan</a>";
                    return "Sudah dilaksanakan";
                }
            }
        } else {
            return 'Belum waktunya ujian';
        }
    }

    public function ikut_ujian($id_ujian = '') {
        if ($id_ujian == '') {
            redirect('ujian');
        }

        $siswa = $this->detailUser();

        $this->load->model('msite');
        $detail_paket = $this->db->from('detail_jadwal_ujian')
            ->where('id_detail_jadwal_ujian', $id_ujian)
            ->where('kelas', $siswa->kelas)
            ->join('mata_pelajaran', 'mata_pelajaran = id_mata_pelajaran', 'LEFT')
            ->join('master_kelas', 'kelas = id_kelas', 'LEFT')
            ->join('master_jurusan', 'jurusan= id_jurusan', 'LEFT')
            ->join('jadwal_ujian', 'jadwal_ujian= id_jadwal_ujian', 'LEFT')
            ->get()
            ->row();

        if (!$detail_paket) {
            redirect('ujian');
        }

        $data           = array();
        $data['detail'] = $detail_paket;

        $this->render_page($data, 'ujian/ikut_ujian');
    }

    public function konfirmasi_ikut_ujian($idUjian = '') {
        if ($idUjian == '') {
            redirect('ujian');
        }

        $siswa = $this->detailUser();

        //cek dulu apakah siswa pernah ikut ujian atau sedang ujian
        $cek_ujian = $this->db->select('id_ujian_dilaksanakan')
            ->from('ujian_dilaksanakan')
            ->where('detail_jadwal_ujian', $idUjian)
            ->where('peserta', $siswa->id_peserta)
            ->get()
            ->row();

        if ($cek_ujian) {
            redirect('ujian');
        }

        $detail = $this->db->from('detail_jadwal_ujian')
            ->where('id_detail_jadwal_ujian', $idUjian)
            ->where('kelas', $siswa->kelas)
            ->join('jadwal_ujian', 'jadwal_ujian = id_jadwal_ujian', 'LEFT')
            ->join('mata_pelajaran', 'mata_pelajaran = id_mata_pelajaran', 'LEFT')
            ->join('master_kelas', 'kelas = id_kelas', 'LEFT')
            ->get()
            ->row();

        if (!$detail) {
            redirect('ujian');
        }

        //menentukan paket soal
        $paket_soal = $this->db->from('data_paket_soal p')
            ->where('p.mata_pelajaran', $detail->mata_pelajaran)
            ->where('p.kelas', $detail->kelas)
            ->where('p.jurusan', $detail->jurusan)
            ->where('p.tipe_soal', $detail->keterangan)
            ->limit(1)
            ->order_by('RAND()')
            ->get()
            ->row();

        if (!$paket_soal) {
            echo 'Maaf tidak ada paket untuk Mata Pelajaran ' . $detail->nama_mata_pelajaran;
            echo '<a href="' . site_url('ujian') . '"> Klik Untuk Kembali</a>';

            die();
        } else {

            //print_r($paket_soal);
            //die();
            //masukan ke ujian dilaksanakan
            $du                          = array();
            $du['detail_jadwal_ujian']   = $idUjian;
            $du['peserta']               = $siswa->id_peserta;
            $du['paket_soal']            = $paket_soal->id_paket_soal;
            $du['jumlah_soal']           = $paket_soal->jumlah_soal;
            $du['mata_pelajaran']        = $detail->nama_mata_pelajaran;
            $du['jumlah_benar']          = 0;
            $du['keterangan_paket_soal'] = 'NIS:' . $siswa->no_induk . ' Nama:' . $siswa->nama_lengkap . ', Mapel: ' . $detail->nama_mata_pelajaran . ', PAKET SOAL: ' . $paket_soal->deskripsi;
            $du['status_ujian']          = 'BERJALAN';

            $this->db->insert('ujian_dilaksanakan', $du);

            $id = $this->db->insert_id();

            $no = 0;
            $no = $this->add_soal($paket_soal->id_paket_soal, $id, "PILIHAN GANDA", $no, 1);
            $no = $this->add_soal($paket_soal->id_paket_soal, $id, "PILIHAN GANDA KOMPLEKS", $no, 1);
            $no = $this->add_soal($paket_soal->id_paket_soal, $id, "BENAR SALAH", $no, 1);
            $no = $this->add_soal($paket_soal->id_paket_soal, $id, "BENAR SALAH KOMPLEKS", $no, 1);
            $no = $this->add_soal($paket_soal->id_paket_soal, $id, "MENJODOHKAN", $no, 1);
            $no = $this->add_soal($paket_soal->id_paket_soal, $id, "MENGURUTKAN", $no, 1);
            $no = $this->add_soal($paket_soal->id_paket_soal, $id, "JAWABAN SINGKAT", $no, 1);
            $no = $this->add_soal($paket_soal->id_paket_soal, $id, "ESSAY", $no);

            //kirim signal ke server
            if (function_exists('curl_version')) {
                $jadwal = $detail->jadwal_ujian;
                $mapel  = $detail->mata_pelajaran;
                $url    = $this->status_cbt->alamat_server_cbt . 'home/catch_me/';

                $ch      = curl_init();
                $qry_str = "npsn=" . $this->status_cbt->npsn . "&jadwal=" . $jadwal . "&mapel=" . $mapel;
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_TIMEOUT, 3);

                // Set request method to POST
                curl_setopt($ch, CURLOPT_POST, 1);

                // Set query data here with CURLOPT_POSTFIELDS
                curl_setopt($ch, CURLOPT_POSTFIELDS, $qry_str);

                $content = trim(curl_exec($ch));
                curl_close($ch);
            } else {
                //                $pesan = "Harap aktifkan CURL, agar proses dapat berjalan";
            }

            //insert LOG
            //redirect ke halaman ujian
            redirect('ujian/fdo_ujian/' . $id);
        }
    }

    private function add_soal($id_paket_soal, $id_ujian, $tipe_soal, $no = 0, $random = 0) {
        //masukan soal
        $this->db->from('detail_paket_soal')
            ->where('data_paket_soal', $id_paket_soal)
            ->join('bank_soal', 'bank_soal=id_bank_soal', 'LEFT')
            ->where('jenis_soal', $tipe_soal);
        if ($random == 1) {
            $this->db->order_by('RAND()');
        }
        $soal = $this->db->get()
            ->result();

        if ($soal) {
            $so = array();
            foreach ($soal as $s) {
                $no++;
                $d                            = array();
                $d['ujian_yang_dilaksanakan'] = $id_ujian;
                $d['no_soal']                 = $no;
                $d['pertanyaan']              = $s->bank_soal;
                $d['jenis_soal']              = $s->jenis_soal;
                $d['status']                  = 'N';

                array_push($so, $d);
            }

            $this->db->insert_batch('soal_ujian', $so);
        }

        return $no;
    }

    public function fdo_ujian($idUjian = '') {
        $siswa          = $this->detailUser();
        $ujian_berjalan = $this->db->select('*, NOW() as sekarang')
            ->from('ujian_dilaksanakan')
            ->where('id_ujian_dilaksanakan', $idUjian)
            ->where('peserta', $siswa->id_peserta)
            ->join('data_paket_soal', 'paket_soal = id_paket_soal', 'LEFT')
            ->join('detail_jadwal_ujian', 'detail_jadwal_ujian = id_detail_jadwal_ujian', 'LEFT')
            ->get()->row();

        if (!$ujian_berjalan) {
            redirect('ujian');
        }

        $this->load->view('ujian/fdo_ujian', array('idUjian' => $idUjian, 'ujian' => $ujian_berjalan));
    }

    public function do_ujian($idUjian = '', $noSoal = '') {
        if ($idUjian == '') {
            redirect('ujian');
        }

        if ($noSoal == '') {
            $noSoal = 1;
        }

        if ($noSoal == NULL || $noSoal == 0) {
            $noSoal = 1;
        }

        $this->load->library('form_validation');

        $siswa = $this->detailUser();

        $ujian_berjalan = $this->db->select('*, NOW() as sekarang')
            ->from('ujian_dilaksanakan')
            ->where('id_ujian_dilaksanakan', $idUjian)
            ->where('peserta', $siswa->id_peserta)
            ->join('data_paket_soal', 'paket_soal = id_paket_soal', 'LEFT')
            ->join('detail_jadwal_ujian', 'detail_jadwal_ujian = id_detail_jadwal_ujian', 'LEFT')
            ->get()->row();

        if (!$ujian_berjalan) {
            redirect('ujian');
        }

        if ($ujian_berjalan->status_ujian == 'SELESAI') {
            redirect('ujian');
        }

        //print_r($ujian_berjalan);
        //cek waktu
        $mulai       = strtotime($ujian_berjalan->mulai_ujian);
        $sekarang    = strtotime($ujian_berjalan->sekarang);
        $waktu_ujian = $ujian_berjalan->lama_ujian * 60;

        //jika waktu habis
        //update ujian berjalan jadi selesai
        if ($sekarang > ($mulai + $waktu_ujian)) {
            $jumlahBenar = $this->db->select('*')
                ->from('soal_ujian')
                ->where('ujian_yang_dilaksanakan', $idUjian)
                ->where('status', 'B')
                ->get()->num_rows();

            $d                 = array();
            $d['status_ujian'] = 'SELESAI';
            $d['jumlah_benar'] = $jumlahBenar;

            $this->db->where('id_ujian_dilaksanakan', $idUjian);
            $this->db->update('ujian_dilaksanakan', $d);

            redirect('home/logout');
        }

        if ($noSoal > $ujian_berjalan->jumlah_soal) {
            $noSoal = $ujian_berjalan->jumlah_soal;
        }

        $soal = $this->db->select('*, soal_ujian.no_soal as no')
            ->from('soal_ujian')
            ->where('ujian_yang_dilaksanakan', $idUjian)
            ->where('soal_ujian.no_soal', $noSoal)
            ->join('bank_soal', 'pertanyaan = id_bank_soal', 'LEFT')
            ->get()
            ->row();

        if (!$soal) {
            redirect('ujian');
        }

        $sisa_waktu = number_format((($mulai + $waktu_ujian) - $sekarang) / 60, 2, '.', ',');

        //print_r($soal);

        $jawaban = $this->db->from('soal_ujian')
            ->where('ujian_yang_dilaksanakan', $idUjian)
            ->get()
            ->result();

        $j    = array();
        $mark = array();
        if ($jawaban) {
            foreach ($jawaban as $v) {
                $j[$v->no_soal]    = $v->jawaban;
                $mark[$v->no_soal] = $v->waktu_jawab == 0 ? "T" : "A";
            }
        }

        $data            = array();
        $data['ujian']   = $ujian_berjalan;
        $data['soal']    = $soal;
        $data['sisa']    = $sisa_waktu;
        $data['jawaban'] = $j;
        $data['mark']    = $mark;

        $this->render_page($data, 'ujian/ujian');
    }

    public function send_snapshot() {
        $this->load->library('upload');

        // Ambil idpeserta dari POST data
        $idpeserta = $this->input->post('idpeserta');

        // Tentukan path upload
        $upload_path = './assets/snapshoots/' . $idpeserta;

        // Buat folder jika belum ada
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0755, true); // Buat folder dengan permission 0755
        }

        // Konfigurasi upload
        $config['upload_path']   = $upload_path; // Directory to save the snapshot
        $config['allowed_types'] = 'jpg|jpeg|png'; // Allowed file types
        $config['max_size']      = 2048; // Max file size in KB
        $config['file_name']     = date('YmdHis'); // Menggunakan timestamp sebagai nama file

        $this->upload->initialize($config);

        // Check if a file was uploaded
        if (isset($_FILES['snapshot']) && $_FILES['snapshot']['error'] == 0) {
            if ($this->upload->do_upload('snapshot')) {
                $data = $this->upload->data();
                // Anda bisa menyimpan informasi file ke database jika diperlukan
                echo json_encode(['status' => 'success', 'file_name' => $data['file_name']]);
            } else {
                echo json_encode(['status' => 'error', 'message' => $this->upload->display_errors()]);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No file uploaded or upload error.']);
        }
    }

    public function simpan_jawaban($no = 0, $id_detail = 0, $jawab = "A") {
        $jawaban_essay   = $this->input->post('jawaban', true);
        $jawaban_pg_ulti = $this->input->post('jawaban_pg_ulti', true);
        $id_ujian        = $this->input->post('soal_ujian', true);
        if ($id_ujian == "") {
            $id_ujian = $no;
        }
        $detail_ujian = $this->input->post('id_ujian_dilaksanakan', true);
        if ($detail_ujian == "") {
            $detail_ujian = $id_detail;
        }

        //get detail soal
        $soal = $this->db->select('*, soal_ujian.no_soal as no')
            ->from('soal_ujian')
            ->where('id_soal_ujian', $id_ujian)
            ->join('bank_soal', 'id_bank_soal=pertanyaan', 'LEFT')
            ->get()
            ->row();

        if (!$soal) {
            die();
            redirect('ujian');
        }

        $d               = array();
        $d['jenis_soal'] = $soal->jenis_soal;

        if ($soal->jenis_soal == "ESSAY") {
            $d['status']        = 'N';
            $d['jawaban_essay'] = $jawaban_essay;
            $d['kunci_jawaban'] = $soal->kunci_jawaban_essay;
        } elseif ($soal->jenis_soal == "JAWABAN SINGKAT") {
            $d['jawaban_essay'] = $jawaban_essay;
            //kalkulasi

            $kunci = $soal->kunci_jawaban_singkat;
            $jawab_benar_array = explode("#", $kunci);
            $jawab_benar       = isset($jawab_benar_array[0]) ? $jawab_benar_array[0] : "Tidak ada";
            $skor              = isset($jawab_benar_array[1]) ? $jawab_benar_array[1] : 0;

            echo $jawaban_essay;

            if (strtolower($jawaban_essay) == strtolower($jawab_benar)) {
                $d['status']     = 'B';
                $d['skor_ujian'] = number_format($skor, 2);
            } else {
                $d['skor_ujian'] = 0;
            }

            print_r($d);
            die();
        } elseif ($soal->jenis_soal == "BENAR SALAH KOMPLEKS") {
            $desk  = $soal->jawaban_bs_multi != "" ? json_decode($soal->jawaban_bs_multi) : [];
            $hasil = array();
            $kunci = array();
            $skor  = 0;
            $no    = 0;
            foreach ($desk as $v) {
                $kk = str_replace("&#13;", "", trim(strip_tags($v->kunci)));
                //pernyataan, skor, kunci
                $jb = $this->input->post("jawaban_" . $no, true);
                if ($jb == $kk) {
                    $skor += $v->skor;
                }

                array_push($hasil, $jb);
                array_push($kunci, $kk);
                $no++;
            }

            $d['skor_ujian']    = number_format($skor, 2);
            $d['jawaban_lain']  = json_encode($hasil);
            $d['kunci_jawaban'] = json_encode($kunci);
        } elseif ($soal->jenis_soal == "MENGURUTKAN") {
            $desk  = $soal->jawaban_mengurutkan != "" ? json_decode($soal->jawaban_mengurutkan) : [];
            $hasil = array();
            $kunci = array();
            $skor  = 0;
            $no    = 0;

            foreach ($desk as $v) {
                //pernyataan, skor, kunci
                $jb = $this->input->post("jawaban_" . $v->urutan, true);
                if ($jb == $v->urutan) {
                    $skor += $v->skor;
                }

                $hasil[$v->urutan] = $jb;
                $kunci[$v->urutan] = $v->pertanyaan;
                $no++;
            }

            $d['skor_ujian']    = number_format($skor, 2);
            $d['jawaban_lain']  = json_encode($hasil);
            $d['kunci_jawaban'] = json_encode($kunci);
        } elseif ($soal->jenis_soal == "MENJODOHKAN") {
            $desk  = $soal->jawaban_menjodohkan != "" ? json_decode($soal->jawaban_menjodohkan) : [];
            $hasil = array();
            $skor  = 0;
            $no    = 0;

            $kunci = str_replace(" ", "", $soal->kunci_jawaban_menjodohkan);
            $kunci = explode(",", $kunci);

            $max_no = count($desk->pernyataan) > count($desk->pasangan) ? count($desk->pernyataan) : count($desk->pasangan);
            for ($i = 1; $i <= $max_no; $i++) {
                //pernyataan, skor, kunci
                $jb  = $this->input->post("pernyataan_" . $i, true);
                $jb2 = $this->input->post("pasangan_" . $i, true);

                if ($jb != "" && $jb2 != "") {
                    $item = $jb . "*" . $jb2;
                    if (!in_array($item, $hasil)) {
                        array_push($hasil, $item);

                        foreach ($kunci as $k) {
                            if (strpos($k, "#") !== false) {
                                $det = explode("#", $k);
                                if ($item == $det[0]) {
                                    $skor += $det[1] * 1;
                                }
                            } else {
                                if ($item == $k) {
                                    $skor += 1;
                                }
                            }
                        }
                    }
                }

                $no++;
            }

            $d['skor_ujian']    = number_format($skor, 2);
            $d['jawaban_lain']  = json_encode($hasil);
            $d['kunci_jawaban'] = $soal->kunci_jawaban_menjodohkan;
        } elseif ($soal->jenis_soal == "BENAR SALAH") {
            $jawab = $this->input->post('jawaban', true);

            $d['jawaban_bs'] = $jawab;
            //kalkulasi

            if ($jawab == $soal->kunci_jawaban_bs) {
                $d['skor_ujian'] = number_format($soal->skor_bs, 2);
            } else {
                $d['skor_ujian'] = 0;
            }

            $d['kunci_jawaban'] = $soal->kunci_jawaban_bs;
        } elseif ($soal->jenis_soal == "PILIHAN GANDA") {
            $d['jawaban'] = $jawab;

            if ($jawab == $soal->kunci_jawaban) {
                $d['status'] = 'B';

                $prop            = "skor_" . strtolower($jawab);
                $d['skor_ujian'] = number_format($soal->$prop, 2);
            } else {
                $d['status']     = 'S';
                $d['skor_ujian'] = 0;
            }

            $d['kunci_jawaban'] = $soal->kunci_jawaban;
        } elseif ($soal->jenis_soal == "PILIHAN GANDA KOMPLEKS") {
            $d['status']           = 'N';
            $d['jawaban_pg_multi'] = $jawaban_pg_ulti;

            $jb = explode(",", $jawaban_pg_ulti);
            $jb = array_filter($jb);

            $benar = 0;
            $salah = 0;
            if (count($jb) > 0) {
                $kunci       = str_replace(" ", "", $soal->kunci_jawaban_multi);
                $kunci       = explode(",", $kunci);
                $kunci       = array_filter($kunci);
                $total_kunci = count($kunci);

                foreach ($jb as $j) {
                    if ($j != "") {
                        if (in_array($j, $kunci)) {
                            $benar++;
                            // $d['status'] = 'B';
                            // $prop        = "skor_" . strtolower($j);
                            // $skor += $soal->$prop;
                        } else {
                            $salah++;
                            // $d['status']     = 'S';
                            // $d['skor_ujian'] = 0;
                        }
                    }
                }

                //SKORING
                $skor = 0;
                if ($total_kunci == 2) {
                    if ($benar == 2) {
                        $skor = 3;
                    } elseif ($benar == 1 && $salah == 1) {
                        $skor = 0;
                    } elseif ($benar == 1 && $salah == 0) {
                        $skor = 1.5;
                    }
                } elseif ($total_kunci == 3) {
                    if ($benar == 3) {
                        $skor = 3;
                    } elseif ($benar == 1 && $salah == 2) {
                        $skor = 0;
                    } elseif ($benar == 2 && $salah == 1) {
                        $skor = 1;
                    } elseif ($benar == 2 && $salah == 0) {
                        $skor = 2;
                    } elseif ($benar == 1 && $salah == 0) {
                        $skor = 1;
                    }
                }

                $d['skor_ujian'] = number_format($skor, 2);
            }

            $d['kunci_jawaban'] = $soal->kunci_jawaban_multi;
        }

        $d['waktu_jawab'] = date('Y-m-d H:i:s');

        // echo $benar.', ', $salah.','.$total_kunci;
        // echo "<hr>";
        // print_r($d);
        // die();

        $this->db->where('id_soal_ujian', $id_ujian);
        $this->db->update('soal_ujian', $d);

        redirect('ujian/do_ujian/' . $detail_ujian . '/' . ($soal->no + 1));
    }

    public function selesaikan_ujian() {
        if ($this->uri->segment(3) === FALSE) {
            redirect('ujian');
        } else {
            $idUjian = $this->uri->segment(3);
        }

        //cari jumlah benar
        $jumlahBenar = $this->db->select('*')
            ->from('soal_ujian')
            ->where('ujian_yang_dilaksanakan', $idUjian)
            ->where('status', 'B')
            ->get()->num_rows();

        $d                 = array();
        $d['status_ujian'] = 'SELESAI';
        $d['jumlah_benar'] = $jumlahBenar;

        $this->db->where('id_ujian_dilaksanakan', $idUjian);
        $this->db->update('ujian_dilaksanakan', $d);

        //redirect ke halaman ujian
        redirect('ujian');
    }

    public function hasil_ujian() {
        echo 'DISABLED';
        die();
        if ($this->uri->segment(3) === FALSE) {
            redirect('ujian');
        } else {
            $idUjian = $this->uri->segment(3);
        }

        $siswa = $this->detailUser();

        $this->load->library('grocery_CRUD');
        $crud = new grocery_CRUD();
        $crud->set_table('ujian_dilaksanakan');
        $crud->set_subject('Hasil');
        $crud->where('id_ujian_dilaksanakan', $idUjian);
        $crud->where('peserta', $siswa->id_peserta);
        $crud->where('status_ujian', 'SELESAI');

        $crud->set_relation('detail_jadwal_ujian', 'detail_jadwal_ujian', 'lama_ujian');

        $crud->columns('mata_pelajaran', 'detail_jadwal_ujian', 'jumlah_soal', 'jumlah_benar');

        $crud->display_as('detail_jadwal_ujian', 'Lama Ujian');

        $crud->unset_operations();
        $crud->unset_jquery();

        $output = $crud->render();

        $this->render_page($output, 'ujian/crud');
    }

    //private function
    private function validate_user() {
        $usr_sess = $this->session->userdata('cbt_sess_pelaksana');
        if (is_array($usr_sess)) {
            $akses = $usr_sess['akses'];
            if ($akses == 'SISWA') {
                //okay, lets pass
            } else if ($akses == 'ADMIN') {
                redirect('admin', 'refresh');
            } else {
                redirect('home', 'refresh');
            }
        } else {
            redirect('home/login', 'refresh');
        }
    }

    private function render_page($data = array(), $template = '') {
        if (is_object($data)) {
            $data = (array) $data;
        }
        $data['judul_halaman'] = $this->title;
        $data['status_cbt']    = $this->status_cbt;

        $this->load->view('admin/header', $data);
        $this->load->view('ujian/top_menu');
        $this->load->view($template);
        $this->load->view('admin/footer');
    }

    private function detailUser() {
        $session_user = $this->session->userdata('cbt_sess_pelaksana');

        if (is_array($session_user)) {
            $id = $session_user['id_user'];

            $detail_siswa = $this->db->from('siswa')
                ->where('id_peserta', $id)
                ->get()
                ->row();

            return $detail_siswa;
        } else {
            return FALSE;
        }
    }
}
