<!--main-container-part-->
<div id="content">
    <!--breadcrumbs-->
    <div id="content-header">
        <div id="breadcrumb"> <a href="<?php echo site_url('admin'); ?>" title="Go to Home" class="tip-bottom"><i class="icon-home"></i> Home</a></div>
    </div>
    <!--End-breadcrumbs-->

    <!--Action boxes-->
    <div class="container-fluid">
        <?php
                        $path_file = FCPATH . 'assets/uploads/tanggal_upload.txt';

                        if (file_exists($path_file)) {
                            $tanggal_update = trim(file_get_contents($path_file));
                            $class_alert    = status_waktu_class($tanggal_update);
                            $yang_lalu      = waktu_yang_lalu($tanggal_update);
                        ?>
                            <div class="alert <?php echo $class_alert; ?>">
                                <i class="icon-time"></i>
                                Terakhir sinkronisasi nilai adalah
                                <strong><?php echo date('d M Y H:i', strtotime($tanggal_update)); ?></strong>
                                (<?php echo $yang_lalu; ?>)
                            </div>
                        <?php
                        } else {
                        ?>
                            <div class="alert alert-warning">
                                <i class="icon-info-sign"></i>
                                Belum pernah dilakukan upload nilai.
                            </div>
                        <?php
                        }
                        ?>

        <?php
        if (!$status_cbt) {
        ?>

            <div class="row-fluid">
                <div class="span12">
                    <h4>Aplikasi belum bisa melakukan ujian. silahkan lakukan singkronisasi terlebih dahulu</h4>
                    <hr />
                    <div class="widget-box">
                        <div class="widget-title"> <span class="icon"> <i class="icon-list"></i> </span>
                            <h5>Silahkan isi form di bawah ini</h5>
                        </div>
                        <div class="widget-content">
                            <?php
                            if (isset($keterangan) && $keterangan != '') {
                            ?>
                                <div class="alert alert-error alert-block">
                                    <?php echo $keterangan; ?>
                                </div>
                            <?php
                            }
                            ?>
                            <form action="" method="POST">
                                <div class="form-group">
                                    <label>Alamat Server (IP Server)</label>
                                    <input type="text" name="ip_server" />
                                </div>
                                <div class="form-group">
                                    <label>Token (Diberikan oleh admin Pusat)</label>
                                    <input type="text" name="token" />
                                </div>
                                <div class="form-group">
                                    <label>ID SERVER PELAKSANA</label>
                                    <?php
                                    $kode_unix = substr(md5(time()), 0, 5);
                                    ?>
                                    <input type="hidden" value="<?php echo $kode_unix; ?>" name="unix" />
                                    <span class="label label-important">
                                        <h4><?php echo $kode_unix; ?></h4>
                                    </span>
                                </div>
                                <hr />
                                <button type="submit" class="btn btn-primary">Simpan Pengaturan</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        } else {
        ?>
            <div class="row-fluid">
                <div class="span12">
                    <div class="row-fluid">
                        <div class="span7">
                            <h4>Selamat datang, silahkan melakukan singkronisasi data jika diperlukan</h4>
                        </div>
                        <div class="span5">
                            <a href="" class="btn btn-success" id="link_server" style="padding: 10px; border-radius: 4px;">SERVER PUSAT</a>
                        </div>
                    </div>
                    <div class="row-fluid" style="margin-top: 10px;">
                        <div class="span7">
                            <h4>Update Status</h4>
                        </div>
                        <div class="span5">
                            <a href="javascript:void(0);" class="btn btn-success" id="cek_status" style="padding: 10px; border-radius: 4px;">Checking...</a>
                        </div>
                    </div>
                    <div class="widget-box">
                        <div class="widget-title"> <span class="icon"> <i class="icon-refresh"></i> </span>
                            <h5>Hasil Syncronisasi</h5>
                        </div>
                        <div class="widget-content">
                            <table>
                                <tr>
                                    <td><b>Nama Sekolah</b></td>
                                    <td>: <?php echo $status_cbt->nama_sekolah; ?></td>
                                </tr>
                                <tr>
                                    <td><b>NPSN</b></td>
                                    <td>: <?php echo $status_cbt->npsn; ?></td>
                                </tr>
                                <tr>
                                    <td><b>Jumlah Siswa</b></td>
                                    <td>
                                        <?php
                                        $dt = $this->db->query("SELECT jurusan, nama_jurusan, COALESCE(COUNT(id_peserta), 0)as jumlah FROM `siswa` LEFT JOIN master_jurusan ON (id_jurusan=jurusan) GROUP BY jurusan")->result();
                                        if ($dt) {
                                            foreach ($dt as $v) {
                                                echo ': ' . $v->nama_jurusan . ' (' . $v->jumlah . ' Orang)<br/>';
                                            }
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><b>Soal</b></td>
                                    <td>
                                        <?php
                                        $dt = $this->db->query("SELECT mata_pelajaran, nama_mata_pelajaran, COALESCE(COUNT(id_bank_soal), 0)as jumlah FROM `bank_soal` LEFT JOIN mata_pelajaran ON (id_mata_pelajaran=mata_pelajaran) GROUP BY mata_pelajaran")->result();
                                        if ($dt) {
                                            foreach ($dt as $v) {
                                                echo ': ' . $v->nama_mata_pelajaran . ' (' . $v->jumlah . ' Butir Soal)<br/>';
                                            }
                                        }
                                        ?>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="span6">
                    <div class="widget-box">
                        <div class="widget-title"> <span class="icon"> <i class="icon-user"></i> </span>
                            <h5>User yang sedang Online/Ujian</h5>
                        </div>
                        <div class="widget-content nopadding">
                            <iframe src="<?php echo site_url('admin/history/'); ?>" width="100%" height="450" style="border:none;" title="history"></iframe>
                        </div>
                    </div>
                </div>
                <div class="span6">
                    <div class="widget-box">
                        <div class="widget-title"> <span class="icon"> <i class="icon-time"></i> </span>
                            <h5>User yang Sudah Mengikuti Ujian</h5>
                        </div>
                        <div class="widget-content nopadding">
                            <iframe src="<?php echo site_url('admin/data_sudah_ujian/'); ?>" width="100%" height="450" style="border:none;" title="data"></iframe>
                        </div>
                    </div>
                </div>
            </div>
            <script>
                $(document).ready(function() {
                    $.ajax({
                        type: "GET",
                        crossDomain: true,
                        url: "<?php echo $status_cbt->alamat_server_cbt . 'home/status_client/' . $status_cbt->token_cbt; ?>",
                        success: function(result) {
                            if (result.keterangan !== "") {
                                $("#link_server").text(result.keterangan);
                            }

                            console.log("GET STATUS: SUKSES, " + result);

                            if (result.status === "aktif") {
                                $("#link_server").removeClass("btn-danger").addClass("btn-success");
                            } else {
                                $("#link_server").removeClass("btn-success").addClass("btn-danger");
                            }
                        },
                        error: function(xhr, status, error) {
                            console.log("GET STATUS: GAGAL, " + error);
                            $("#link_server").removeClass("btn-success btn-danger").addClass("btn-warning");
                            $("#link_server").text("GAGAL MENDAPATKAN INFO DARI PUSAT");
                        }
                    });

                    const cekStatusBtn = $('#cek_status');

                    function cekStatus() {
                        cekStatusBtn.text('Checking...').removeClass('btn-success btn-danger btn-warning').addClass('btn-primary');

                        // Ajax request ke backend untuk cek status
                        $.ajax({
                            type: "GET",
                            crossDomain: true,
                            url: "<?php echo site_url('admin/cek_update'); ?>",
                            dataType: 'json',
                            success: function(result) {
                                if (result.message !== "") {
                                    cekStatusBtn.text(result.message);
                                }

                                if (result.status === "ada") {
                                    cekStatusBtn.removeClass("btn-danger btn-warning").addClass("btn-success");
                                    cekStatusBtn.attr("href", "<?= site_url('admin/update_aplikasi') ?>");
                                } else {
                                    cekStatusBtn.removeClass("btn-success btn-warning").addClass("btn-danger");
                                }
                            },
                            error: function(xhr, status, error) {
                                cekStatusBtn.removeClass("btn-success btn-danger").addClass("btn-warning");
                                cekStatusBtn.text("GAGAL ...");
                            }
                        });
                    }

                    // Jalankan pengecekan otomatis saat halaman dimuat
                    cekStatus();

                    cekStatusBtn.on('click', function(e) {
                        e.preventDefault(); // Prevent the default action of the button

                        // Check if the href is not 'javascript:void(0);'
                        if (cekStatusBtn.attr('href') !== 'javascript:void(0);') {
                            // Navigate to the URL specified in the href
                            window.location.href = cekStatusBtn.attr('href');
                        } else {
                            // If href is 'javascript:void(0);', call the cekStatus function
                            cekStatus(); // Call the function to check status
                        }
                    });
                });

                setTimeout(function() {
                    window.location.reload(1);
                }, 90000);
            </script>
        <?php
        }
        ?>
        <hr />
    </div>
</div>

<!--end-main-container-part-->
